<?php
include_once '../config.php';

function getBusinessBySubdomain($subdomain) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT * FROM businesses WHERE subdomain = ?");
    $stmt->bind_param("s", $subdomain);
    $stmt->execute();
    $result = $stmt->get_result();
    $business = $result->fetch_assoc();
    $stmt->close();
    return $business;
}

function getPlansByBusinessId($business_id) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT * FROM plans WHERE business_id = ?");
    $stmt->bind_param("i", $business_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $plans = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    return $plans;
}

function getBusinessById($business_id) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT * FROM businesses WHERE business_id = ?");
    $stmt->bind_param("i", $business_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $business = $result->fetch_assoc();
    $stmt->close();
    return $business;
}

function getPlanById($plan_id) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT * FROM plans WHERE plan_id = ?");
    $stmt->bind_param("i", $plan_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $plan = $result->fetch_assoc();
    $stmt->close();
    return $plan;
}

function getAddonsByBusinessId($business_id) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT * FROM addons WHERE business_id = ?");
    $stmt->bind_param("i", $business_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $addons = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    return $addons;
}

function getDeliveryAreaByBusinessId($business_id) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT delivery_area FROM businesses WHERE business_id = ?");
    $stmt->bind_param("i", $business_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $delivery_area = $result->fetch_assoc()['delivery_area'];
    $stmt->close();
    return $delivery_area;
}

function getCutoffTimeByBusinessId($business_id) {
    global $mysqli;
    $stmt = $mysqli->prepare("SELECT cutoff_time FROM businesses WHERE business_id = ?");
    $stmt->bind_param("i", $business_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $cutoff_time = $result->fetch_assoc()['cutoff_time'];
    $stmt->close();
    return $cutoff_time;
}


?>
