<?php
session_start();
include 'config.php';
include 'lib/database.php';



// // Check if form data is set in the query parameter
if (!isset($_GET['formData'])) {
    die('Form data not found. Please go back and try again.');
}

$formData = json_decode($_GET['formData'], true);

// // Validate form data
if (!isset($formData['business_id']) || !isset($formData['plan_id'])) {
    die('Invalid form data. Please go back and try again.');
}



$business_id = $formData['business_id'];
$plan_id = $formData['plan_id'];
$user_lname = $formData['lname'];
$amount = $formData['amount'];
$message = $formData['message'];

try {
    // Fetch business details
    $business = getBusinessById($business_id);
    if (!$business) {
        die('Business not found.');
    }

    // Fetch plan details
    $plan = getPlanById($plan_id);
    if (!$plan) {
        die('Plan not found.');
    }


} catch (Exception $e) {
    die('Error: ' . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>eTransfer Payment</title>
    <style>
        body {
            font-family: 'League Spartan', sans-serif;
            background-color: #f8f8f8;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 300px;
        }
        .container label {
            display: block;
            margin-top: 10px;
            color: #393939;
        }
        .container .field {
            margin-top: 5px;
            padding: 8px;
            border: 1px solid #d3d3d3;
            border-radius: 4px;
            width: 100%;
            box-sizing: border-box;
        }
        .container .timer {
            font-size: 1.2em;
            color: #f57722;
        }
        
        .container .disclaimer {
            margin-top: 15px;
            color: red;
            font-weight: bold;
        }
        
        .container button {
            background-color: #f57722;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            margin-top: 20px;
            width: 100%;
            font-family: 'League Spartan', sans-serif;
        }
        .container button:hover {
            background-color: #ff9d2a;
        }
    </style>
    <script>
        // Timer functionality
        var timeLeft = 600; // 10 minutes in seconds
        function startTimer() {
            var timer = document.getElementById('timer');
            var interval = setInterval(function() {
                var minutes = Math.floor(timeLeft / 60);
                var seconds = timeLeft % 60;
                timer.textContent = minutes + ':' + (seconds < 10 ? '0' : '') + seconds;
                timeLeft--;
                if (timeLeft < 0) {
                    clearInterval(interval);
                    timer.textContent = "Expired";
                }
            }, 1000);
        }
        window.onload = startTimer
        
                // Function to trigger email parsing and verification
        function triggerVerification() {
            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'verify_payment.php', true);
            xhr.setRequestHeader('Content-Type', 'application/json');
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    var response = JSON.parse(xhr.responseText);
                    alert(response.message);
                }
            };
            xhr.send(JSON.stringify({message: "<?php echo $message; ?>"}));
        }
        
    </script>
</head>
<body>
    <div class="container">
        <h2>INTERAC e-Transfer</h2>
        <p>To complete your registration, please send an e-Transfer with the following details:</p>
        <label>Recipient Name:</label>
        <div class="field"><?php echo htmlspecialchars($business['name']); ?></div>
        <label>Recipient Email:</label>
        <div class="field"><?php echo htmlspecialchars($business['email']); ?></div>
        <label>Amount:</label>
        <div class="field">$<?php echo htmlspecialchars($plan['price']); ?> CAD</div>
        <div class="disclaimer">Please ensure you use the exact message below. This is required for payment verification.</div>

        <label>Message:</label>
        <div class="field"><?php echo htmlspecialchars($message); ?></div>
        <label>Security Question:</label>
        <div class="field"><?php echo htmlspecialchars($business['name']); ?></div>
        <label>Security Answer:</label>
        <div class="field"><?php echo htmlspecialchars($user_lname); ?></div>
        <p class="timer">Transaction valid for: <span id="timer">10:00</span></p>
        <button onclick="triggerVerification()">I have sent the e-transfer</button>
    </div>
</body>
</html>

