<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=League+Spartan:wght@100..900&family=Lexend+Deca:wght@100..900&display=swap" rel="stylesheet">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registration Form</title>
    <style>
           body {
            font-family: 'League Spartan', sans-serif;
            background: #536856;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0;
        }

        form {
            background: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 300px;
            margin-top: 20px;
            margin-bottom: 20px;
        }

        label {
            color: #000000;
            display: block;
            margin-top: 10px;
        }

        input[type="text"],
        input[type="email"],
        input[type="tel"],
        select {
            width: 100%;
            padding: 8px;
            margin-top: 5px;
            border: 1px solid #d3d3d3;
            border-radius: 4px;
            box-sizing: border-box;
        }

        input[type="text"]:focus,
        input[type="email"]:focus,
        input[type="tel"]:focus,
        select:focus {
            border-color: #f57722;
            outline: none;
        }

        button {
            background-color: #cd9a48;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            margin-top: 20px;
            width: 100%;
            font-family: "League Spartan", sans-serif;
        }

        button:hover {
            background-color: #ff9d2a;
        }

        .multiselect {
            position: relative;
            display: inline-block;
            width: 100%;
        }

        .selectBox {
            position: relative;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid #d3d3d3;
            border-radius: 4px;
            padding: 8px;
            box-sizing: border-box;
            cursor: pointer;
            background-color: #fff;
        }

        .selectBox::after {
            content: '';
            position: absolute;
            right: 10px;
            border: solid black;
            border-width: 0 1px 1px 0;
            display: inline-block;
            padding: 4px;
            transform: rotate(45deg);
            pointer-events: none;
        }

        .overSelect {
            position: absolute;
            left: 0;
            right: 0;
            top: 0;
            bottom: 0;
        }

        .checkboxes {
            display: none;
            border: 1px solid #d3d3d3;
            border-radius: 4px;
            box-sizing: border-box;
            background-color: #fff;
            position: absolute;
            z-index: 1;
            width: 100%;
            max-height: 150px;
            overflow-y: auto;
        }

        .checkboxes label {
            display: block;
            margin: 0;
            padding: 8px;
            cursor: pointer;
        }

        .checkboxes label:hover {
            background-color: #ddd;
        }

        .checkboxes input[type="checkbox"] {
            margin-right: 10px;
        }
        .selectBox select {
    display: none; /* Hide the actual select box */
}

.selectBox {
    background-color: #fff; /* Change background color */
    color: #000; /* Change text color */
}

.selected-addons {
    display: inline-block;
    max-width: 100%;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
}

.checkbox-label {
    color: #000; /* Change checkbox label color */
}
    </style>
</head>

<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/66678b069a809f19fb3c36f9/1i027e41q';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->

<body>
    <form id="signupForm" onsubmit="checkAddressInDeliveryArea(); return false;">
        <img src="../logo.png" alt="Business Logo" style="display: block; margin: 0 auto 20px auto; max-width: 250px;">
        <input type="hidden" name="business_id" value="<?php echo htmlspecialchars($business['business_id']); ?>">
        
        <label for="fname">First Name:</label>
        <input type="text" id="fname" name="fname" required>
        
        <label for="lname">Last Name:</label>
        <input type="text" id="lname" name="lname" required>
        
        <label for="email">Email:</label>
        <input type="email" id="email" name="email">
        
        <label for="address">Address:</label>
        <input type="text" id="address" name="address" required>
        
        <label for="apt_no">Apt./ Suite Number:</label>
        <input type="text" id="apt_no" name="apt_no">
        
        <label for="city">City:</label>
        <input type="text" id="city" name="city" required>
        
        <label for="state">State:</label>
        <input type="text" id="state" name="state" required>
        
        <label for="postal_code">Postal Code:</label>
        <input type="text" id="postal_code" name="postal_code" required>
        
        <input type="hidden" id="address_lat" name="address_lat" required>
        <input type="hidden" id="address_long" name="address_long" required>
        
        <label for="phone">Phone:</label>
        <input type="tel" id="phone" name="phone" required>
        
        <label for="plan">Select Plan:</label>
        <select name="plan_id" id="plan_id" required>
            <?php foreach ($plans as $plan) { ?>
                <option value="<?php echo htmlspecialchars($plan['plan_id']); ?>" data-price="<?php echo htmlspecialchars($plan['price']); ?>" data-quantity="<?php echo htmlspecialchars($plan['quantity']); ?>" data-delivery-days="<?php echo htmlspecialchars($plan['delivery_days']); ?>">
                    <?php echo htmlspecialchars($plan['name']) . " - $" . htmlspecialchars($plan['price']); ?>
                </option>
            <?php } ?>
        </select>
        
<label for="addons">Select Add-ons:</label>
<div class="multiselect">
    <div class="selectBox" onclick="toggleCheckboxes()">
        <div class="selected-addons">Select Add-ons</div>
        <div class="overSelect"></div>
    </div>
    <div id="checkboxes" class="checkboxes">
        <?php foreach ($addons as $addon) { ?>
            <label class="checkbox-label" for="addon_<?php echo $addon['addon_id']; ?>">
                <input type="checkbox" id="addon_<?php echo $addon['addon_id']; ?>" name="addons[]" value="<?php echo $addon['addon_id']; ?>" data-price="<?php echo htmlspecialchars($addon['price']); ?>">
                <?php echo htmlspecialchars($addon['name']) . " - $" . htmlspecialchars($addon['price']); ?>
            </label>
        <?php } ?>
    </div>
</div>

        
        <label for="delivery_notes">Delivery Notes:</label>
        <input type="text" id="delivery_notes" name="delivery_notes" required>
        
        <label for="subscription_type">Subscription Type:</label>
        <div style="display: flex; align-items: center; gap: 10px;">
            <label for="delivery">
                <input type="radio" id="delivery" name="subscription_type" value="delivery" required> Delivery
            </label>
            <label for="pickup">
                <input type="radio" id="pickup" name="subscription_type" value="pick-up" required> Pick Up
            </label>
        </div>

        <div style="margin-top: 20px; color: #ffffff;">
            <strong>Total: $<span id="total_price">0.00</span></strong>
        </div>
        
        <button type="submit">Sign Up</button>
    </form>
    
    <script>
document.addEventListener('DOMContentLoaded', function() {
    const planSelect = document.getElementById('plan_id');
    const addonCheckboxes = document.querySelectorAll('input[name="addons[]"]');
    const totalPriceElement = document.getElementById('total_price');
    const selectedAddons = document.querySelector('.selected-addons');

    function calculateTotal() {
        let totalPrice = parseFloat(planSelect.options[planSelect.selectedIndex].getAttribute('data-price'));
        let selected = [];

        addonCheckboxes.forEach(checkbox => {
            if (checkbox.checked) {
                totalPrice += parseFloat(checkbox.getAttribute('data-price'));
                selected.push(checkbox.parentNode.textContent.trim());
            }
        });

        totalPriceElement.textContent = totalPrice.toFixed(2);
        selectedAddons.textContent = selected.length ? selected.join(', ') : 'Select Add-ons';
    }

    planSelect.addEventListener('change', calculateTotal);
    addonCheckboxes.forEach(checkbox => checkbox.addEventListener('change', calculateTotal));

    calculateTotal(); // Initial calculation
});
function toggleCheckboxes() {
    const checkboxes = document.getElementById("checkboxes");
    if (checkboxes.style.display === "block") {
        checkboxes.style.display = "none";
    } else {
        checkboxes.style.display = "block";
    }
}
        
        function isPointInPolygon(point, polygon) {
            var x = point[0], y = point[1];
            var inside = false;
            for (var i = 0, j = polygon.length - 1; i < polygon.length; j = i++) {
                var xi = polygon[i][0], yi = polygon[i][1];
                var xj = polygon[j][0], yj = polygon[j][1];
                var intersect = ((yi > y) != (yj > y)) && (x < (xj - xi) * (y - yi) / (yj - yi) + xi);
                if (intersect) inside = !inside;
            }
            return inside;
        }
        
        function checkAddressInDeliveryArea() {
            const lat = parseFloat(document.getElementById('address_lat').value);
            const lng = parseFloat(document.getElementById('address_long').value);
            const point = [lng, lat];
        
            const businessId = document.querySelector('#signupForm [name="business_id"]').value;
            fetch(`../check_delivery_area.php?business_id=${businessId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.error) {
                        alert('Error: ' + data.error);
                        return;
                    }

                    console.log('Delivery Area Data:', data.delivery_area);
                    const deliveryArea = JSON.parse(data.delivery_area);
                    const polygon = deliveryArea.features[0].geometry.coordinates[0];
                    console.log('Parsed Polygon:', polygon);

                    const isInDeliveryArea = isPointInPolygon(point, polygon);

                    if (!isInDeliveryArea) {
                        alert('We do not serve this area at the moment.');
                    } else {
                        fetchCutoffTimeAndSubmitForm();
                    }
                })
                .catch(error => {
                    console.error('Error fetching delivery area:', error);
                    alert('An error occurred while checking the delivery area. Please try again later.');
                });
        }

        function fetchCutoffTimeAndSubmitForm() {
            const businessId = document.querySelector('#signupForm [name="business_id"]').value;

            fetch(`../get_cutoff_time.php?business_id=${businessId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.error) {
                        alert('Error: ' + data.error);
                        return;
                    }

                    const cutoffTime = data.cutoff_time;
                    console.log('Cutoff Time:', cutoffTime);

                    const now = new Date();
                    console.log('Current Time:', now);
                    
                    const cutoff = new Date();
                    const [hours, minutes, seconds] = cutoffTime.split(':').map(Number);
                    cutoff.setHours(hours, minutes, seconds || 0, 0);
                    console.log('Cutoff Date Time:', cutoff);

                    let startDate = new Date();
                    if (now.getTime() > cutoff.getTime()) {
                        startDate.setDate(now.getDate() + 2);
                    } else {
                        startDate.setDate(now.getDate() + 1);
                    }
                    
                    startDate.setHours(0, 0, 0, 0);

                    const selectedPlan = document.querySelector('#plan_id option:checked');
                    const planQuantity = selectedPlan.getAttribute('data-quantity');
                    const planDeliveryDays = selectedPlan.getAttribute('data-delivery-days');
                    const endDate = calculateEndDate(startDate, planDeliveryDays, planQuantity);

                    console.log('Adjusted Start Date:', startDate);
                    console.log('Calculated End Date:', endDate);

                    submitForm(startDate, endDate);
                })
                .catch(error => {
                    console.error('Error fetching cutoff time:', error);
                    alert('An error occurred while fetching the cutoff time. Please try again later.');
                });
        }
        
        function calculateEndDate(startDate, deliveryDays, quantity) {
            const daysMap = { "Mon": 1, "Tue": 2, "Wed": 3, "Thu": 4, "Fri": 5, "Sat": 6, "Sun": 0 };
            const daysArray = deliveryDays.split('-').map(day => daysMap[day]);
            let deliveriesMade = 0;
            let currentDate = new Date(startDate);

            while (deliveriesMade < quantity) {
                if (daysArray.includes(currentDate.getDay())) {
                    deliveriesMade++;
                }
                currentDate.setDate(currentDate.getDate() + 1);
            }

            currentDate.setDate(currentDate.getDate() - 1);

            return currentDate.toISOString().split('T')[0];
        }

        function submitForm(startDate, endDate) {
            var formData = {
                business_id: document.querySelector('#signupForm [name="business_id"]').value,
                fname: document.getElementById('fname').value,
                lname: document.getElementById('lname').value,
                email: document.getElementById('email').value,
                address: document.getElementById('address').value,
                apt_no: document.getElementById('apt_no').value,
                city: document.getElementById('city').value,
                state: document.getElementById('state').value,
                postal_code: document.getElementById('postal_code').value,
                phone: document.getElementById('phone').value,
                plan_id: document.getElementById('plan_id').value,
                delivery_notes: document.getElementById('delivery_notes').value,
                address_lat: document.getElementById('address_lat').value,
                address_long: document.getElementById('address_long').value,
                start_date: startDate.toISOString().split('T')[0],
                end_date: endDate,
                subscription_type: document.querySelector('input[name="subscription_type"]:checked').value,
                addons: Array.from(document.querySelectorAll('input[name="addons[]"]:checked')).map(cb => cb.value)
            };

            console.log('Form Data:', formData);

            fetch('https://app.tiffy.io/api/register.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                alert('Registration Successful: ' + data.message);
                if (data.success) {
                    document.getElementById('signupForm').reset();
                   // Prepare the URL parameters for redirection
            const urlParams = new URLSearchParams({
                customer: JSON.stringify(data.customer),
                subscription: JSON.stringify(data.subscription),
                addons: JSON.stringify(data.addons)
            });

            // Redirect to thankyou.php with the data
            window.location.href = `thankyou.php?${urlParams.toString()}`;

                }
            })
            .catch(error => {
                alert('Error during registration: ' + error.message);
            });
        }
        
        function initAutocomplete() {
            var input = document.getElementById('address');
            var options = {
                types: ['geocode']
            };
            var autocomplete = new google.maps.places.Autocomplete(input, options);
            autocomplete.setFields(['address_components', 'formatted_address', 'geometry']);

            autocomplete.addListener('place_changed', function() {
                var place = autocomplete.getPlace();
                console.log(place);

                var latitude = place.geometry.location.lat();
                var longitude = place.geometry.location.lng();

                console.log('Latitude:', latitude, 'Longitude:', longitude);

                var streetNumber = '';
                var route = '';
                var addressComponents = place.address_components;
                for (var i = 0; i < addressComponents.length; i++) {
                    var addressType = addressComponents[i].types[0];
                    if (addressType === 'street_number') {
                        streetNumber = addressComponents[i].long_name;
                    } else if (addressType === 'route') {
                        route = addressComponents[i].long_name;
                    }
                }

                var streetAddress = streetNumber + ' ' + route;
                document.getElementById('address').value = streetAddress;

                var city, state, postalCode;
                for (var i = 0; i < addressComponents.length; i++) {
                    var addressType = addressComponents[i].types[0];
                    if (addressType === 'locality') {
                        city = addressComponents[i].long_name;
                    } else if (addressType === 'administrative_area_level_1') {
                        state = addressComponents[i].long_name;
                    } else if (addressType === 'postal_code') {
                        postalCode = addressComponents[i].long_name;
                    }
                }
                document.getElementById('city').value = city || '';
                document.getElementById('state').value = state || '';
                document.getElementById('postal_code').value = postalCode || '';

                document.getElementById('address_lat').value = latitude;
                document.getElementById('address_long').value = longitude;
            });
        }
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyClZFMpyjz0y_pitzhAderm5K6ZNTVRNCY&libraries=places&callback=initAutocomplete" async defer></script>
</body>
</html>
