<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thank You</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #536856;
            color: #ffffff;
            padding: 20px;
            height: 100vh;
            margin: 0;
        }
        .container {
            background: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: 0 auto;
            text-align: center;
        }
        h1 {
            color: #ffffff;
        }
        .message {
            background-color: #ffffff;
            color: #000000;
            padding: 20px;
            border-radius: 8px;
            margin-top: 20px;
            text-align: left;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .message p {
            margin: 0 0 10px 0;
        }
        .message strong {
            color: #e74c3c;
        }
        .message em {
            color: #8B0000;
        }
    </style>
</head>
<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/669da3a332dca6db2cb3368f/1i3bsedpt';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->
<body>
    <div class="container">
        <img src="../logo.png" alt="Business Logo" style="display: block; margin: 0 auto 20px auto; max-width: 250px;">
        <h1>Thank You for Registering!</h1>
        <div class="message">
            <p>Hi <strong id="fname"></strong>,</p>
            <p>Your subscription is now active and will begin on <strong id="start_date"></strong> and end on <strong id="end_date"></strong>.</p>
            <p>Your meals will be delivered to <strong id="address"></strong>, <strong id="city"></strong>, <strong id="state"></strong>, <strong id="postal_code"></strong><strong id="apt_no"></strong>.</p>
            <p>If you would like to make any changes to your subscription or have any questions, please reach out to our customer service team. We're here to help!</p>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const urlParams = new URLSearchParams(window.location.search);
            const customer = JSON.parse(urlParams.get('customer'));
            const subscription = JSON.parse(urlParams.get('subscription'));
            const addons = JSON.parse(urlParams.get('addons'));

            document.getElementById('fname').textContent = customer.f_name;
            document.getElementById('start_date').textContent = subscription.start_date;
            document.getElementById('end_date').textContent = subscription.end_date;

            document.getElementById('address').textContent = customer.address;
            document.getElementById('city').textContent = customer.city;
            document.getElementById('state').textContent = customer.state;
            document.getElementById('postal_code').textContent = customer.postal_code;
            if(customer.apt_no){
                document.getElementById('apt_no').textContent = ","+ customer.apt_no;
            }
        });
    </script>
</body>
</html>


