<?php
include 'config.php';

require_once 'php-imap/src/PhpImap/Exceptions/ConnectionException.php';
require_once 'php-imap/src/PhpImap/Exceptions/InvalidParameterException.php';
require_once 'php-imap/src/PhpImap/DataPartInfo.php';
require_once 'php-imap/src/PhpImap/IncomingMailAttachment.php';
require_once 'php-imap/src/PhpImap/IncomingMailHeader.php';
require_once 'php-imap/src/PhpImap/IncomingMail.php';
require_once 'php-imap/src/PhpImap/Mailbox.php';
require_once 'php-imap/src/PhpImap/Imap.php';

use PhpImap\Mailbox;

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$message = $data['message'] ?? null;

if (!$message) {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit();
}

// Set up the mailbox connection
$mailbox = new Mailbox(
    '{imap.gmail.com:993/imap/ssl}INBOX', // Adjust the IMAP settings according to your email provider
    'your-email@gmail.com', // Your email
    'your-email-password', // Your email password
    __DIR__
);

try {
    $mailsIds = $mailbox->searchMailbox('UNSEEN');
    if (!$mailsIds) {
        echo json_encode(['success' => false, 'message' => 'No new emails found']);
        exit();
    }

    foreach ($mailsIds as $mailId) {
        $mail = $mailbox->getMail($mailId);

        $emailBody = $mail->textHtml ?: $mail->textPlain;
        preg_match('/Message:\s*(.*)/i', $emailBody, $messageMatch);
        preg_match('/has sent you \$(\d+.\d{2})/i', $emailBody, $amountMatch);

        $emailMessage = $messageMatch[1] ?? '';
        $emailAmount = $amountMatch[1] ?? '';

        if ($emailMessage === $message && $emailReferenceNumber === $reference_number) {
            // Connect to your database
            $db = getDbInstance();
            
            // Verify the payment in your database
            $transaction = $db->where('message', $message)
                              ->where('amount', $emailAmount)
                              ->getOne('transactions');
            
            if ($transaction) {
                // Mark the transaction as complete
                $db->where('transaction_id', $transaction['transaction_id'])
                   ->update('transactions', ['status' => 'Complete']);

                // Activate the subscription
                activateSubscription($transaction['customer_id'], $transaction['plan_id']);
                
                echo json_encode(['success' => true, 'message' => 'Payment verified and subscription activated']);
                exit();
            }
        }
    }

    echo json_encode(['success' => false, 'message' => 'Payment not found or verification failed']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}

function activateSubscription($customer_id, $plan_id) {
    $db = getDbInstance();

    $start_date = date('Y-m-d');
    $end_date = date('Y-m-d', strtotime("+1 month"));

    $new_subscription = [
        'customer_id' => $customer_id,
        'plan_id' => $plan_id,
        'start_date' => $start_date,
        'end_date' => $end_date,
        'delivery_notes' => '',
        'status' => 'Active'
    ];
    $db->insert('subscriptions', $new_subscription);
}
?>
