<?php
include 'config.php';
include 'lib/database.php';

// Get subdomain
$host = explode('.', $_SERVER['HTTP_HOST']);
$subdomain = $host[0];  // Assuming 'demo' in 'demo.tiffy.io'

// Get business by subdomain
$business = getBusinessBySubdomain($subdomain);

if (!$business) {
    die('Business not found!');
}

// Get plans associated with the business
$plans = getPlansByBusinessId($business['business_id']);

// Get add-ons associated with the business
$addons = getAddonsByBusinessId($business['business_id']);

// Include the HTML header
include 'templates/header.php';

// Include the signup form and pass the plans to it
include 'templates/signupForm.php';

?>
